 /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :   Apr 13 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief Call to HOSTQA_ATP_Message with appropriate params
   *
   *  \version  SST_Ext_ATP_Utility.c#1:csrc:1
   *  \author   taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/

#include "SST_Ext_ATP_MM.h"
#include "ExtApp_HOST_TST_Message_MM.h"
#include "SST_Ext_ATP_DataTstVectors.h"
#include "SST_Ext_ATP_AuthenticatorsTstVectors.h"
#include "MW_ATP_UTIL_funcs.h"
#include "SST_EXT_TST.h"


 #if TST_USE_INIT_TERMINATE_MODULE
/************************ Defines ******************************/
Ext_ATP_MMDataOpTestDataStruct SEP_ATP_MMDataOpTestData[]=
{
    
    {
        /*TST_Data*/
        {0x83,0x08,0x4c,0xf8,0xbb,0x88,0x8f,0x22,0xa2,0xe6,0x7e,0x7a,0x6b,0x56,0x0c,0x76,
        0xc7,0x98,0x8b,0x70,0xb6,0x79,0x1f,0x4b,0x9c,0x9c,0x73,0x59,0x97,0x7a,0xaa,0x7c,
        0x10,0xa8,0x99,0x8c,0x90,0x59,0x33,0xf9,0xd5,0x23,0x44,0xb2,0x26,0x06,0x63,0x45,
        0xe3,0xaa,0x21,0x47,0x60,0xe8,0x87,0xf6,0xf3,0x8c,0xc0,0x1d,0x4c,0x59,0x12,0x38,
        0x05,0x4e,0x13,0xd9,0x7a,0x28,0x19,0x4a,0xdb,0x28,0xf2,0x74,0x80,0x16,0xd5,0xff,
        0x7c,0x86,0x99,0xbb,0x74,0x5a,0x25,0x3f,0xb2,0x88,0x28,0xd0,0x75,0x1e,0x0a,0x84,
        0x8b,0x83,0x22,0xa6,0x22,0xff,0x29,0x5d,0xdc,0x7d,0xee,0x89,0x21,0x90,0x4c,0xee,
        0xb9,0xb5,0x59,0x94,0x9a,0xd8,0xe1,0x6d,0xfe,0x19,0x13,0x39,0xb9,0xcf,0x79,0xa7},
        /*TST_DataSize*/
        128,
         /*TST_OutputData*/
        {0x00},
         /*TST_AesKey*/
        {0x20,0x76,0x91,0x5c,0x52,0x5e,0xa3,0x0b,0xdc,0x3f,0xc7,0x8b,0xd5,0x21,0xf4,0xca},
       /*TST_ChallengeBuff*/
        {0x9f,0xed,0xd0,0x32,0x9e,0x90,0x4b,0xd5,0xb7,0x85,0xed,0xaf,0x2e,0x4f,0x3b,0xfb,
        0xe3,0xa4,0x29,0xb1,0x81,0xcb,0xeb,0x05,0xf9,0x48,0x08,0x30,0x2f,0xbb,0xb0,0x74},
        /*TST_ChallengeBuffSize*/  
        32,
        /*TST_EncChallengeBuff*/
        {0x00},
        /*TST_EncChallengeBuffSize*/
        32,
        
    },
   
};
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
extern DxError_t      EXT_TST_ATP_Error;
extern DxUint8_t      EXT_FailureFunctionNameOut[TST_FUNC_STRING_LEN];
extern DxError_t      EXT_TST_TestStatus;
extern DxChar         TST_Ext_MainDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
extern DxChar         TST_Ext_SecondaryDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
extern DxVosFile      TST_Ext_MainDBFileHandle;
extern DxVosFile      TST_Ext_SecondaryDBFileHandle;
extern DxByte_t       TST_Ext_Workspace[TST_WORKSPACE_SIZE_BYTES];

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_InitTerminate      
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *   Verify that init and terminate commands work
 *  
 * Algorithm:       
 *    1. Terminate the SST.
 *    2. Init the SST.
 *    3. Call HOSTQA_ATP_Message_MM (first part).
 *    4. Terminate the SST.
 *    5. Init the SST.
 *    6. Call HOSTQA_ATP_Message_MM (second part).
 *
 *******************************************************************************/ 
 
 
 DxError_t SST_Ext_ATP_MM()
 {
 	 
    /********* TST Variables Definitions ************/
    char                        TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_Ext_ATP_MM";
    SSTInitInfo_t               aInitInfo;
    static DxBool_t             TST_FirstRun  = DX_FALSE;
    /********* TST Variables initialization *********/
    EXT_TST_TestStatus = TESTPASS;

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
   	
	ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_MasterTestName,"\n"));
	
   
	#ifndef DX_CC5_SEP_PLAT 
		if(!TST_FirstRun)
			TST_FirstRun = DX_TRUE;
		else
		{
			ATP_LOG_TST_PRINT((SST_TST_MSG,"In order to run this test again a cold boot must take place - please restart the application\n"));
			return TST_Status;
		}
   #endif
   
      	
	/* Terminate the SST */
    /*-------------------*/

    EXT_TST_ATP_Error = SST_Terminate();

    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
  
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;
    
   
    /* Init the SST for operations */
    /*-----------------------------------*/
      EXT_TST_ATP_Error = SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                   (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                   &aInitInfo,
                   TST_Ext_Workspace,
                   TST_Ext_WorkspaceSizeInBytes);

     EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
   
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;

	/* Call HOSTQA_ATP_Message_MM (first part) */
    /*-----------------------------------------*/
	EXT_TST_ATP_Error = HOSTQA_ATP_Message_MM(DX_SEP_HOST_SEP_PROTOCOL_SST_MM_1_OP_CODE,
	                                             SEP_ATP_MMDataOpTestData);
	                                             
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_Message_MM", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
                                               
	                                             
	                                             
   	/* Terminate the SST */
    /*-------------------*/

    EXT_TST_ATP_Error = SST_Terminate();

    EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Terminate", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
  
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;
    
   
    /* Init the SST again for operations */
    /*-----------------------------------*/
      EXT_TST_ATP_Error = SST_Init((DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
                   (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
                   &aInitInfo,
                   TST_Ext_Workspace,
                   TST_Ext_WorkspaceSizeInBytes);

     EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"SST_Init", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
   
    if (EXT_TST_TestStatus!=TST_PASS)
       goto EXIT;

	/* Call HOSTQA_ATP_Message_MM (second part) */
    /*-----------------------------------------*/
			
 	EXT_TST_ATP_Error = HOSTQA_ATP_Message_MM(DX_SEP_HOST_SEP_PROTOCOL_SST_MM_2_OP_CODE,
	                                             SEP_ATP_MMDataOpTestData);
	                                             
	EXT_TST_TestStatus = TST_ATP_CheckErrorReturn(EXT_TST_ATP_Error,"HOSTQA_ATP_Message_MM", 
		                                          "SST_Ext_ATP_InitTerminate",TST_MasterTestName);											
    			
                                   
		                                          											
     EXIT:
		  return EXT_TST_TestStatus;												                        
 }
 #endif

